<?
require_once("inc/nocache.php");
$dbid=(int)$_GET["ID"];
if($dbid>MAXDB)
  {
  pError("Invalid DB ID given!",1);
  }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//DE" "http://www.w3.org/TR/html4/loose.dtd"> 
<html lang="en">
<head>
  <title>Oracle Information Site V<?echo($SITE_VER);?> - <?echo($ora_user[$dbid]."@".$ora_host[$dbid]);?></title>
<?
require("inc/header.inc");
?>
</head>        
<body>
<div id="main" align="center">
<?
require("inc/title.inc");
?>
<span class="REDSUBTITLES">All Tablespaces</span><br>
<br>
<a href="index2.php?ID=<?echo($dbid);?>" class="SMALL">&lt;&lt;&nbsp;back to main menu</a>
<p>
<?
// Query three DBA Views to gather all required Tablespace informations. 
$myquery=<<<EOM
SELECT  COUNT(H1) AS H1CNT,
        H2,
        SUM(H3) AS H3SUM,
        SUM(H4) AS H4SUM,
        H5,
        H6,
        H7,
        H8
  FROM
  (
SELECT  t1.TABLESPACE_NAME AS H1,
        t1.TABLESPACE_NAME AS H2, 
        d1.BYTES AS H3,
        (SELECT SUM(f1.BYTES) FROM DBA_FREE_SPACE f1 WHERE f1.FILE_ID=d1.FILE_ID) as H4,
        LOWER(t1.STATUS) AS H5,
        DECODE(t1.LOGGING,'LOGGING','Yes','No') AS H6,
        DECODE(t1.CONTENTS,'TEMPORARY','Yes','No') AS H7,
        LOWER(t1.EXTENT_MANAGEMENT) AS H8
  FROM  DBA_DATA_FILES d1, DBA_TABLESPACES t1
 WHERE  t1.TABLESPACE_NAME=d1.TABLESPACE_NAME
UNION
SELECT  t2.TABLESPACE_NAME H1,
        t2.TABLESPACE_NAME H2, 
        d2.BYTES H3,
        (SELECT SUM(f2.BYTES) FROM DBA_FREE_SPACE f2 WHERE f2.FILE_ID=d2.FILE_ID) H4,
        LOWER(t2.STATUS) AS H5,
        DECODE(t2.LOGGING,'LOGGING','Yes','No') H6,
        DECODE(t2.CONTENTS,'TEMPORARY','Yes','No') H7,
        LOWER(t2.EXTENT_MANAGEMENT) H8
  FROM  DBA_TEMP_FILES d2, DBA_TABLESPACES t2
 WHERE  t2.TABLESPACE_NAME=d2.TABLESPACE_NAME
   )
 GROUP  BY H2,H5,H6,H7,H8
 ORDER  BY H2
EOM;
$db = new db_oci8;
$db->Connect($ora_user[$dbid],$ora_pass[$dbid],$ora_host[$dbid]);
$db->QueryResult($myquery);
$lv=0;
$usetext = "TEXT";
?>
<table cellspacing="1" cellpadding="4" border="0" width="650" class="MAINBORDER">
<tr>
  <th>#</th>
  <th>Tablespace Name</th>
  <th>Size</th>
  <th>Used</th>
  <th>Free</th>
  <th>% full</th>
  <th>Status</th>
  <th>Logging</th>
  <th>Temporary</th>
  <th>Management</th>
  <th>&nbsp;</th>
</tr>
<?
$datafiles = 0;
while($r = $db->FetchResult())
  {
  if($lv % 2) $myback = "TBG1";
  else $myback = "TBG2";
  echo("<tr class=\"".$myback."\">\n");
  echo("  <td align=\"center\" title=\"Count of datafiles for this tablespace\">".$r['H1CNT']."</td>\n");
  echo("  <td align=\"left\" title=\"Click on Tablespace name for datafile details\"><a href=\"showTSDetails.php?ID=".$dbid."&amp;TS=".BASE64_Encode($r['H2'])."&amp;TMP=".$r['H7']."\">".$r['H2']."</a></td>\n");
  echo("  <td align=\"right\" nowrap title=\"Total tablespace size\">".ConvertSize($r['H3SUM'])."&nbsp;</td>\n");
  echo("  <td align=\"right\" nowrap title=\"Used space in this tablespace\">".ConvertSize(($r['H3SUM']-$r['H4SUM']))."&nbsp;</td>\n");
  printf("  <td align=\"right\" nowrap title=\"Free space in this tablespace\">%s&nbsp;</td>\n",ConvertSize($r['H4SUM']));
  if($r['H3SUM']) $pcnt = 100-((float)$r['H4SUM'] * 100) / (float)$r['H3SUM'];
  else $pcnt = 0;
  printf("  <td align=\"right\" nowrap>%2.2f%%</td>\n",$pcnt);
  echo("  <td align=\"center\">".$r['H5']."</td>\n");
  echo("  <td align=\"center\">".$r['H6']."</td>\n");
  echo("  <td align=\"center\">".$r['H7']."</td>\n");
  if(StrToUpper($r['H8'])=="LOCAL") 
    {
    echo("  <td align=\"center\"><b>".UCWords($r['H8'])."</b></td>\n");
    }
  else 
    {
    echo("  <td align=\"center\">".UCWords($r['H8'])."</td>\n");
    }
  if(100-((float)$r['H4SUM'] * 100) / (float)$r['H3SUM'] >=95 && $r['H7'] != "Yes")
    {
    $mywarn = 'led_red.gif';
    $wtext  = 'Tablespace is grown to 95% in size!';
    }
  else 
    {
    $mywarn = 'led_green.gif';
    $wtext  = 'Tablespace space is okay';
    }
  echo("  <td align=\"center\"><img src=\"images/".$mywarn."\" width=\"13\" height=\"13\" border=\"0\" alt=\"led\" title=\"".$wtext."\"></td>\n");
  echo("   </tr>\n"); 
  $lv++;
  $totalbytes+=(int)$r['H3SUM'];
  $totalfree+=(int)$r['H4SUM'];
  $datafiles+=(int)$r['H1CNT'];
  }
$db->FreeResult();
$db->Disconnect();
if($lv % 2) $myback = "TBG1";
else $myback = "TBG2";
echo("<tr class=\"$myback\">\n");
echo("  <td colspan=\"2\" align=\"right\"><b>Total:</b></td>\n");
echo("  <td align=\"right\" nowrap><b>".ConvertSize($totalbytes)."&nbsp;</b></td>\n");
echo("  <td align=\"right\" nowrap><b>".ConvertSize($totalbytes-$totalfree)."&nbsp;</b></td>\n");
echo("  <td align=\"right\" nowrap><b>".ConvertSize($totalfree)."&nbsp;</b></td>\n");
if($totalbytes) $tpcnt = 100-((float)$totalfree * 100) / (float)$totalbytes;
else $tpcnt = 0;
printf("  <td align=\"right\" nowrap><b>%2.2f%%</b></td>\n",$tpcnt);
echo("  <td colspan=\"5\" align=\"right\"><b>Tablespaces: ".$lv." | Datafiles: ".$datafiles."&nbsp;</b></td>\n");
echo("</tr>\n"); 
?>
</table>
<br>
</div>
<?
printFooter(1);
?>
</body>
</html>
