<?
/* Function list:
 *
 * oError()         - General Oracle Error handling function
 * getmicrotime()   - Retrieves microseconds
 */

function oError($ohandle,$errmsg="",$stop=0)
  {
  if($ohandle!=false) $mydata = @OCIError($ohandle);
  else $mydata = @OCIError();
  if($mydata["code"]!="" && $mydata["code"]!=0)
    {
    if($errmsg!="")
      {
      printf("<SPAN CLASS=\"TEXTERR\">%s</SPAN><BR>\n<SPAN CLASS=\"TEXTERR\">%s</SPAN>\n",$errmsg,$mydata["message"]);
      }  
    else
      {
      printf("<BR>\n<SPAN CLASS=\"TEXTERR\">%s</SPAN>\n",$mydata["message"]);
      }
    @error_log($errmsg." ".@preg_replace("/\\n|\\r/","",$mydata["message"])." in file ".$_SERVER["SCRIPT_FILENAME"]);
    }  
  if($stop) 
    {
    echo("</BODY>\n</HTML>\n");
    @OCILogoff($ohandle);
    exit;
    }
  }
function pError($errstring,$stop=0)
  {
  if($errstring!="")
    {
    echo("<FONT FACE=\"Tahoma,Arial,Sans-Serif\" COLOR=\"#FF0000\" SIZE=\"4\">".$errstring."</FONT>\n<BR>\n");
    }  
  if($stop) exit;
  }
function ConvertSize($size)
  {
  $sizes = array(" bytes"," kb"," MB"," GB"," TB");
  $mysize = (float)$size;
  if($mysize<1024) return(round($mysize,2).$sizes[0]);
  $c=0;
  while($mysize>1024)  
   {
   $mysize = $mysize/1024;
   $c++;
   }
  return(round($mysize,2).$sizes[$c]);
  }
function getmicrotime()
  {
  list($usec, $sec) = explode(" ",microtime());
  return ((float)$usec + (float)$sec);
  }
function printFooter($code = 0)
  {
  global $start_timer,$db,$dbid;
  echo("<div align=\"center\">\n<br>\n");
  echo("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
  echo("<tr valign=\"bottom\">\n");
  echo("  <td align=\"left\" width=\"25%\" class=\"BORDERTOP\"><small>".strftime("%c")."</small></td>\n");
  switch($code)
    {
    case  0:    echo("<td width=\"50%\" class=\"BORDERTOP\" align=\"center\"><small>&nbsp;</small></td>\n");
                break;
    case  1:    echo("<td width=\"50%\" class=\"BORDERTOP\" align=\"center\"><a href=\"index2.php?ID=".$dbid."\" class=\"SMALL\">&lt;&lt;&nbsp;back to index</a>&nbsp;|&nbsp;<a href=\"#MAIN\" class=\"SMALL\">Top</a></td>\n");
                break;
    case  2:    if($db)
                  {
                  $str = "Using PHP v".phpversion()." / DB-Class v".$db->GetClassVersion();
                  }
                else
                  {
                  $str = "&nbsp;";
                  }
                echo("<td width=\"50%\" class=\"BORDERTOP\" align=\"center\"><small>".$str."</small></td>\n");
                break;
    }
  echo("  <td align=\"right\" width=\"25%\" class=\"BORDERTOP\"><small>");
  $et = getmicrotime();
  if(isset($start_timer))
    {
    if($db)
      {
      echo("Queries: ".$db->getQueryCount()." / ");
      }
    echo("Exec time: ".round($et-$start_timer,4)."sec.");
    }
  else
    {
    echo("&nbsp;");
    }
  echo("</small></td>\n");
  echo("</tr>\n</table>\n<br>\n</div>\n");
  }
?>
