<?php
/*****************************************************************************
 * Diese Datei wird von allen PHP Skripten aufgerufen.
 * Mit den header() Aufrufen wird dem Webbrowser mitgeteilt, das er die
 * Seiten nicht cachen soll. 
 *****************************************************************************/

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");               // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");  // always modified
header("Cache-Control: no-store, no-cache, must-revalidate");   // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false);      // HTTP/1.1

/*****************************************************************************
 * Hiermit wird die Oracle Class verfgbar gemacht. Diese wird jedoch noch
 * nicht erzeugt, das muss explizit durch den Aufruf des Constructors erfolgen.
 *****************************************************************************/

require_once("oci8_class.php");

/*****************************************************************************
 * Diese Funktion erstellt die Seiten Navigation. Dadurch spart man sich das 
 * Kopieren der ganzen HTML Parts, da diese Funktion automatisch die notwendigen
 * HTML Parameter erstellt. 
 * $title => Seiten Titel
 * $prev  => URL zur vorhergehenden Seite oder NULL
 * $next  => URL zur nchsten Seite oder NULL
 * $php   => Name der originalen PHP Seite zur Quelltext Anzeige
 *
 * Ausserdem wird automatisch ein Link erzeugt um die aktuelle Seite als PHP Quelltext
 * anzeigen zu lassen. Dazu wird aus dem PHP Super-Array $_SERVER[] der volle
 * Pfad des aktuellen Script ermittelt und dann via basename() nur noch der
 * Dateiname extrahiert. Danach baut das echo() Kommando einen Link zu der
 * PHP Seite showsource.php mit dem ermittelten Dateinamen auf.
 *****************************************************************************/

function printNavigation($title, $prev, $next, $php)
  {
  echo("<table width=\"99%\" border=\"0\">\n");
  echo("<tr>\n");
  echo("  <td align=\"left\" width=\"75%\"><h2>".$title."</h2></td>\n");
  echo("  <td align=\"right\" width=\"25%\"><a href=\"showsource.php?PAGE=".$php."\">Zeige PHP-Quelltext</a>");
  if($php != "index.php")
    {
    echo("&nbsp;|&nbsp;<a href=\"index.php\">Home</a>");
    }
  echo("<br>");
  if(!is_null($prev))
    {
    echo("<a href=\"".$prev."\">&lt;&lt; zur&uuml;ck</a>");  
    }
  if(!is_null($next))
    {
    if(!is_null($prev))
      {
      echo("&nbsp;|&nbsp;");
      }
    echo("<a href=\"".$next."\">weiter &gt;&gt;</a>");  
    }
  echo("</td>\n");
  echo("</tr>\n</table>\n<br>\n");
  }
?>
